#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye : register (c8);
float4 fogData : register (c9);
float4x4 shadowProj : register (c16);
float4x4 shadowView : register (c20);
float4x4 ambientView : register (c24);
float4x4 shadowViewProj : register (c28);

struct VS_OUTPUT
{
  float4 Pos  : POSITION;
#ifdef USEFOG
  float  Fog  : FOG;
#endif   
  float2 Tex  : TEXCOORD0;
 #if AMBIENT == 1
  float2 Amb  : TEXCOORD1;
 #elif FLOAT == 1
  float  Depth: TEXCOORD1; //temp 
 #endif  
};

#if BUMP == 1

 #if FLOAT == 1
 
  #if AMBIENT == 1 // has static ambient shadow
    VS_OUTPUT vs11_shadowProjectBumpAmbientFP (float4 inPos : POSITION)
  #else
    VS_OUTPUT vs11_shadowProjectBumpFP (float4 inPos : POSITION)
  #endif 
  
 #else
 
  #if AMBIENT == 1 // has static ambient shadow
    VS_OUTPUT vs11_shadowProjectBumpAmbient (float4 inPos : POSITION)
  #else
    VS_OUTPUT vs11_shadowProjectBump (float4 inPos : POSITION)
  #endif 
  
 #endif 

#else

 #if FLOAT == 1

  #if AMBIENT == 1 // has static ambient shadow
    VS_OUTPUT vs11_shadowProjectAmbientFP (float4 inPos : POSITION)
  #else
    VS_OUTPUT vs11_shadowProjectFP (float4 inPos : POSITION)
  #endif

 #else
 
  #if AMBIENT == 1 // has static ambient shadow
    VS_OUTPUT vs11_shadowProjectAmbient (float4 inPos : POSITION)
  #else
    VS_OUTPUT vs11_shadowProject (float4 inPos : POSITION)
  #endif
  
 #endif 

#endif
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space (view is the light's view):
  Out.Pos = mul (viewProjMatrix, inPos);
  float4 worldPos = mul (worldMatrix, inPos);

#ifdef USEFOG
  // fog that shadow (in camera space this time)
  float3 eyeVec = worldEye + worldPos;
  Out.Fog = (fogData[1] - (length (eyeVec) * fogData[0]));
#endif   
  
  // projected texture coordinates
  float3 t = mul (shadowView, worldPos);
  Out.Tex.xy =  (mul (shadowProj, t / t.z));
  
 #if AMBIENT == 1
  float3 a = mul (ambientView, worldPos);
  Out.Amb.xy =  (mul (shadowProj, a / a.z));
 #endif 

 #if FLOAT == 1
  Out.Depth = mul (shadowViewProj, inPos).z;
 #endif 

  return (Out);
}

